/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class HydrophilousModifier
extends Modifier
implements BreakSpeedModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook {
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        if (player != null && player.m_204029_(FluidTags.f_13131_)) {
            if (player.m_21023_(MobEffects.f_19599_)) {
                event.setNewSpeed(event.getNewSpeed());
            } else if (!EnchantmentHelper.m_44934_((LivingEntity)player)) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            } else {
                event.setNewSpeed(event.getNewSpeed() + (float)(5 * modifier.getLevel()));
            }
        }
    }

    public int getPriority() {
        return 60;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player != null && player.m_204029_(FluidTags.f_13131_)) {
            return damage + (float)(modifier.getLevel() * 5);
        }
        return damage;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP);
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null && player.m_204029_(FluidTags.f_13131_)) {
            TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.ATTACK_DAMAGE, (TagKey)TinkerTags.Items.MELEE, (float)(5 * modifier.getLevel()), tooltip);
            if (player.m_21023_(MobEffects.f_19599_)) {
                double percent;
                double scale;
                int amplifier = player.m_21124_(MobEffects.f_19599_).m_19564_() + 1;
                if (amplifier <= 3) {
                    scale = Math.pow(3.0, amplifier);
                    percent = Math.pow(0.3, amplifier);
                } else {
                    scale = Math.pow(3.0, 4.0);
                    percent = Math.pow(0.3, 4.0);
                }
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.hydrophilous.mining_speed1"), (double)(percent * scale), tooltip);
            } else if (!EnchantmentHelper.m_44934_((LivingEntity)player)) {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.hydrophilous.mining_speed2"), (double)5.0, tooltip);
            } else {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.MINING_SPEED, (TagKey)TinkerTags.Items.HARVEST, (float)(5 * modifier.getLevel()), tooltip);
            }
        }
    }
}

